/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.konkrete.input.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.mcp.MCPVersion;

public class DynamicValueHelper {
    public static String convertFromRaw(String in) {
        int width = 0;
        int height = 0;
        String playername = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        String playeruuid = Minecraft.func_71410_x().func_110432_I().func_148255_b();
        String mcversion = MCPVersion.getMCVersion();
        if (Minecraft.func_71410_x().field_71462_r != null) {
            width = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
            height = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
        }
        in = StringUtils.convertFormatCodes((String)in, (String)"&", (String)"\u00a7");
        in = in.replace("%guiwidth%", "" + width);
        in = in.replace("%guiheight%", "" + height);
        in = in.replace("%playername%", playername);
        in = in.replace("%playeruuid%", playeruuid);
        in = in.replace("%mcversion%", mcversion);
        in = DynamicValueHelper.replaceModVersionPlaceolder(in);
        int loaded = DynamicValueHelper.getLoadedMods();
        in = in.replace("%loadedmods%", "" + loaded);
        int total = DynamicValueHelper.getTotalMods();
        if (total < loaded) {
            total = loaded;
        }
        in = in.replace("%totalmods%", "" + total);
        return in;
    }

    public static boolean containsDynamicValues(String in) {
        String s = DynamicValueHelper.convertFromRaw(in);
        return !s.equals(in);
    }

    private static String replaceModVersionPlaceolder(String in) {
        try {
            if (in.contains("%version:")) {
                ArrayList<String> l = new ArrayList<String>();
                int index = -1;
                for (int i = 0; i < in.length(); ++i) {
                    String s = "" + in.charAt(i);
                    if (!s.equals("%")) continue;
                    if (index == -1) {
                        index = i;
                        continue;
                    }
                    String sub = in.substring(index, i + 1);
                    if (sub.startsWith("%version:") && sub.endsWith("%")) {
                        l.add(sub);
                    }
                    index = -1;
                }
                for (String s : l) {
                    Optional o;
                    if (!s.contains(":")) continue;
                    String blank = s.substring(1, s.length() - 1);
                    String mod = blank.split(":", 2)[1];
                    if (!ModList.get().isLoaded(mod) || !(o = ModList.get().getModContainerById(mod)).isPresent()) continue;
                    ModContainer c = (ModContainer)o.get();
                    String version = c.getModInfo().getVersion().toString();
                    in = in.replace(s, version);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private static int getTotalMods() {
        File modDir = new File("mods");
        if (modDir.exists()) {
            int i = 0;
            for (File f : modDir.listFiles()) {
                if (!f.isFile() || !f.getName().toLowerCase().endsWith(".jar")) continue;
                ++i;
            }
            return i + 2;
        }
        return -1;
    }

    private static int getLoadedMods() {
        try {
            return ModList.get().getMods().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

